//+------------------------------------------------------------------+
//|                                                   SAR Colour.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property copyright "Kalenzo"
#property link      "http://www.foreksik.prv.pl"

#property indicator_color1 Red
#property indicator_color2 Green
#property indicator_chart_window
#property indicator_buffers 2

double sarUp[],sarDn[];//buffers
extern double Step = 0.013;
extern double Maximum = 0.2;
extern int Precision = 5;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW,EMPTY,2);
   SetIndexStyle(1,DRAW_ARROW,EMPTY,2);
   SetIndexBuffer(0,sarUp);
   SetIndexBuffer(1,sarDn);
   SetIndexArrow(0,158);
   SetIndexArrow(1,158);
   
   IndicatorShortName("SAR COLORED");
   SetIndexLabel(0,"SAR Up Channel");
   SetIndexLabel(1,"SAR Down Channel");
   
   SetIndexDrawBegin(0,2);
   SetIndexDrawBegin(1,2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- 
   for(int i = 0; i<limit ;i++)
   {
      double sar = NormalizeDouble(iSAR(Symbol(),0,Step,Maximum,i),Precision);
      if(sar >= iHigh(Symbol(),0,i)) 
      {
         sarUp[i] = sar;  
         sarDn[i] = 0;
      }
      else
      {
         sarUp[i] = 0;
         sarDn[i] = sar;
      }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+